//-------------------------------------------------------------------------------
//--    _____
//--   /     \	
//--  /____   \____
//-- / \===\   \==/
//--/___\===\___\/  AVNET
//--     \======/   DESIGN
//--      \====/    SERVICES
//-------------------------------------------------------------------------------
//--
//-- Title: 	
//-- Program: 	
//-- Filename:	system.c
//--
//-- FPGA: 		
//-- Author(s):	Nasser Poureh
//-- Date:		
//--
//-- Purpose:
//--
//-- Disclaimer:
//--	Avnet, Inc. makes no warranty for the use of this code or design.  
//--	This code is provided  "As Is". Avnet, Inc assumes no responsibility for 
//--	any errors, which may appear in this code, nor does it make a commitment 
//--	to update the information contained herein. Avnet, Inc specifically 
//--	disclaims any implied warranties of fitness for a particular purpose.
//--       			 Copyright (c) 2004 Avnet, Inc.
//--               			 All rights reserved.
//--
//-------------------------------------------------------------------------------
//-- Revision List
//-- Version		Date		Changes
//-- 1.0					
//--							
//-------------------------------------------------------------------------------

#include "xuartlite_l.h"
#include "xparameters.h"
#include "xgpio_l.h"
#include "xtmrctr_l.h"
#include "xintc_l.h"
#include "xexception_l.h"

#define true 1
#define false 0

unsigned int count_1 = 0;
static char display_data[8] =	{0xfe, 0xfd, 0xfb, 0xf7, 0xef, 0xdf, 0xbf, 0x7f};





/*
*********************************************************************************************
*                                             timer1_int_handler()
* 
* Description:	The timer1 interrupt handler routine is used to flash the LEDs on the board.
*              
*********************************************************************************************
*/

void timer1_int_handler() {

	unsigned int timer_csr;
	int loop_count, dip_gpio_data, temp_data;

	//	Read timer 0 CSR to see if it raised the interrupt
	timer_csr = XTmrCtr_mGetControlStatusReg(XPAR_XPS_TIMER_0_BASEADDR, 0);
 

	if (timer_csr & XTC_CSR_INT_OCCURED_MASK) {

		XGpio_mSetDataReg(XPAR_LEDS_8BIT_BASEADDR, 1, display_data[count_1]);
 	
	//	Clear the timer interrupt
	XTmrCtr_mSetControlStatusReg(XPAR_XPS_TIMER_0_BASEADDR, 0, timer_csr);
	}
		
	count_1 = count_1 + 1;

	if (count_1 == 8) {
		count_1 = 0;
	}
}



/*
*********************************************************************************************
*                                             timer0_int_handler()
* 
* Description:	The timer2 interrupt handler routine is used to read the DIP switches on the
*				    board and display the switch settings on the Hyper Terminal.
*              
*********************************************************************************************
*/

void timer0_int_handler() {

	unsigned int csr;
	int loop_count, dip_gpio_data, temp_data;


	//	Read timer 0 CSR to see if it raised the interrupt
	csr = XTmrCtr_mGetControlStatusReg(XPAR_XPS_TIMER_1_BASEADDR, 0);
  
	if (csr & XTC_CSR_INT_OCCURED_MASK) {
    
		dip_gpio_data = XGpio_mGetDataReg(XPAR_DIP_SWITCHES_8BIT_BASEADDR, 1) & 0x000000FF;
		
	
  		xil_printf("\r");
		xil_printf("   DIP Switches (SW0-7) = ");

		for (loop_count = 0; loop_count < 8; loop_count++) {
			temp_data = (dip_gpio_data >> (7 - loop_count)) & 0x00000001;
			if (temp_data) {
				xil_printf("ON ");
				}
			else {
				xil_printf("OFF ");
			}
		}

  		xil_printf("               \r");
    
	//	Clear the timer interrupt */
	XTmrCtr_mSetControlStatusReg(XPAR_XPS_TIMER_1_BASEADDR, 0, csr);

	} 

}





main() {

	xil_printf("\033[H\033[J"); //clears the screen
	xil_printf(
"*******************************************************************\r\n"
"*                    _____                                        *\r\n"
"*                   /     \\                                       *\r\n"
"*                  /____   \\____                                  *\r\n"
"*                 / \\===\\   \\==/                                  *\r\n"
"*                /___\\===\\___\\/  AVNET                            *\r\n"
"*                     \\======/   DESIGN                           *\r\n"
"*                      \\====/    SERVICES                         *\r\n"
"*******************************************************************\r\n"
"*      Virtex-5 FXT Evaluation Board Application Design           *\r\n"
"*******************************************************************\r\n"
);

xil_printf("\n\r");



//	The following function calls initialize the GPIO ports. LEDS_8BIT is configured
//	to be an output port while the DIP_SWITCHES_8BIT is configured to be an input port.

	XGpio_mSetDataDirection(XPAR_LEDS_8BIT_BASEADDR, 1, 0x00000000);
	XGpio_mSetDataDirection(XPAR_DIP_SWITCHES_8BIT_BASEADDR, 1, 0xffffffff);


//	Initialize exception handling
	XExc_Init();


//	Register the timer interrupts
	XIntc_RegisterHandler(XPAR_XPS_INTC_0_BASEADDR, XPAR_XPS_INTC_0_XPS_TIMER_0_INTERRUPT_INTR, (XInterruptHandler)timer1_int_handler, (void *)XPAR_XPS_TIMER_0_BASEADDR);
	XIntc_RegisterHandler(XPAR_XPS_INTC_0_BASEADDR, XPAR_XPS_INTC_0_XPS_TIMER_1_INTERRUPT_INTR, (XInterruptHandler)timer0_int_handler, (void *)XPAR_XPS_TIMER_1_BASEADDR);

//	Register external interrupt handler
	XExc_RegisterHandler(XEXC_ID_NON_CRITICAL_INT, (XExceptionHandler)XIntc_LowLevelInterruptHandler, (void *)0);


//	Start the interrupt controller
	XIntc_mMasterEnable(XPAR_XPS_INTC_0_BASEADDR);

//	Set the number of cycles the timers counts before interrupting
	XTmrCtr_mSetLoadReg(XPAR_XPS_TIMER_0_BASEADDR, 0, 7000000);
	XTmrCtr_mSetLoadReg(XPAR_XPS_TIMER_1_BASEADDR, 0, 125000000);

  
//	Reset the timers, and clear interrupts
	XTmrCtr_mSetControlStatusReg(XPAR_XPS_TIMER_0_BASEADDR, 0, XTC_CSR_INT_OCCURED_MASK | XTC_CSR_LOAD_MASK );
	XTmrCtr_mSetControlStatusReg(XPAR_XPS_TIMER_1_BASEADDR, 0, XTC_CSR_INT_OCCURED_MASK | XTC_CSR_LOAD_MASK );
	
  
//	Enable timer interrupts in the interrupt controller
	XIntc_mEnableIntr(XPAR_XPS_INTC_0_BASEADDR, XPAR_XPS_TIMER_0_INTERRUPT_MASK | XPAR_XPS_TIMER_1_INTERRUPT_MASK);
  
  
//	Start the timers
	XTmrCtr_mSetControlStatusReg(XPAR_XPS_TIMER_0_BASEADDR, 0, XTC_CSR_ENABLE_TMR_MASK | XTC_CSR_ENABLE_INT_MASK | XTC_CSR_AUTO_RELOAD_MASK | XTC_CSR_DOWN_COUNT_MASK);
	XTmrCtr_mSetControlStatusReg(XPAR_XPS_TIMER_1_BASEADDR, 0, XTC_CSR_ENABLE_TMR_MASK | XTC_CSR_ENABLE_INT_MASK | XTC_CSR_AUTO_RELOAD_MASK | XTC_CSR_DOWN_COUNT_MASK);
  
//	Enable PPC non-critical interrupt
	XExc_mEnableExceptions(XEXC_NON_CRITICAL);

    while(1);

}
  



