//-----------------------------------------------------------------------------
//
//     XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"
//     SOLELY FOR USE IN DEVELOPING PROGRAMS AND SOLUTIONS FOR
//     XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION
//     AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE, APPLICATION
//     OR STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS
//     IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,
//     AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE
//     FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY
//     WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE
//     IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR
//     REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF
//     INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
//     FOR A PARTICULAR PURPOSE.
//     
//     (c) Copyright 2004 Xilinx, Inc.
//     All rights reserved.
//
//---------------------------------------------------------------------------*/


#include <stdio.h>
#include "xsysace.h"
#include "xstatus.h"
#include "xparameters.h"

#define NUM_SECTORS   100



int main()
{
	XSysAce Ace;                            /* an instance of the device */
	XStatus Result;
	Xuint8 Buffer[XSA_CF_SECTOR_SIZE];      /* fits one sector of data */
	Xuint32 i, j;


	xil_printf("\033[H\033[J"); //clears the screen

	xil_printf(
	"**********************************************************************\r\n"
	"*    This program demonstrates how data is read from or written      *\r\n"
	"*   to a CompactFlash/MicroDrive card in the SystemACE card slot.    *\r\n"
	"*                                                                    *\r\n"
	"**********************************************************************\r\n"
	);

	xil_printf("\n\r");


	/* print out the sector size */
	xil_printf("   1) The sector size is %d bytes\r\n", XSA_CF_SECTOR_SIZE);
  
	/* Initialize the instance. The device defaults to polled mode.*/  	
	Result = XSysAce_Initialize(&Ace, XPAR_SYSACE_COMPACTFLASH_DEVICE_ID);
	if (Result != XST_SUCCESS)
	{
		xil_printf("   Could not initialize the System ACE driver!\r\n");
		return -1;
	}

	/* Get a lock (this is a non-blocking function call to allow the user*/
	/* to do other things while waiting for the lock)*/  
	xil_printf("   2) Getting a lock on the System ACE device...");
	while ((Result = XSysAce_Lock(&Ace, XFALSE)) != XST_SUCCESS);

	xil_printf("done\r\n");
  
	/* Read the sector of data. The starting sector is 0 and the number
	* of sectors to read is 1.
	*
	* In polled mode, this is a blocking call that returns when the sector
	* has been read (or an error occurred).*/ 
	xil_printf("   3) Reading the first %d sectors on the device...", NUM_SECTORS);  
	for (i=0; i < NUM_SECTORS; i++)
	{


   while (!XSysAce_IsCFReady(&Ace));
   Result = XSysAce_SectorRead(&Ace, i, 1, Buffer);
   if (Result != XST_SUCCESS)
   {
     xil_printf("\r\n   Error during read operation. Quitting...\r\n");
     return -2;
   }

	}
    
	xil_printf("done.\r\n");


	xil_printf("   4) Writing the second %d sectors on the device...", NUM_SECTORS);  
	for (i=0; i < NUM_SECTORS; i++)
	{
		for (j = 0; j < XSA_CF_SECTOR_SIZE; j++)
		Buffer[j] = (Xuint8) (i+j);   /* every sector starts with +1 */
      
		while (!XSysAce_IsCFReady(&Ace)) ;
		Result = XSysAce_SectorWrite(&Ace, (i + 100), 1, Buffer);
		if (Result != XST_SUCCESS)
		{
		xil_printf("\r\n   Error during write operation. Quitting...\r\n");
		return -3;
		}
	}    
		xil_printf("done.\r\n");


	/* Release the lock*/ 
	xil_printf("   5) Releasing the lock on the System ACE device...");
	XSysAce_Unlock(&Ace);
	xil_printf("done.\r\n");
  
	return 0;
}

