#define TESTAPP_GEN

/* $Id: xsysace_selftest_example.c,v 1.1 2005/02/08 19:34:29 meinelte Exp $ */
/******************************************************************************
*
*       XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"
*       AS A COURTESY TO YOU, SOLELY FOR USE IN DEVELOPING PROGRAMS AND
*       SOLUTIONS FOR XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE,
*       OR INFORMATION AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE,
*       APPLICATION OR STANDARD, XILINX IS MAKING NO REPRESENTATION
*       THAT THIS IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,
*       AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE
*       FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY
*       WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE
*       IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR
*       REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF
*       INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*       FOR A PARTICULAR PURPOSE.
*
*       (c) Copyright 2005 Xilinx Inc.
*       All rights reserved.
*
******************************************************************************/
/****************************************************************************/
/**
*
* @file xsysace_selftest_example.c
*
* This file contains a design example using the SystemACE driver.
*
* @note
*
* None.
*
* MODIFICATION HISTORY:
*
* Ver   Who  Date     Changes
* ----- ---- -------- -----------------------------------------------
* 1.00a ecm  01/25/05 First release for TestApp integration
*
******************************************************************************/

/***************************** Include Files *********************************/

#include "xsysace.h"
#include "xstatus.h"
#include "xparameters.h"

/************************** Constant Definitions *****************************/

//#define XPAR_SYSACE_0_DEVICE_ID     1 /* should be XPAR_... */

/**************************** Type Definitions *******************************/

/***************** Macros (Inline Functions) Definitions *********************/

/************************** Function Prototypes ******************************/
XStatus XSysAce_SelfTestExample(Xuint16 DeviceId);

/************************** Variable Definitions *****************************/

XSysAce Ace;                            /* an instance of the device */

/******************************************************************************
*
* Main function to call the example.  This function is not included if the
* example is generated from the TestAppGen test tool.
*
******************************************************************************/
#ifndef TESTAPP_GEN
int main(void)
{
    (void)XSysAce_SelfTestExample(XPAR_SYSACE_0_DEVICE_ID);

    return 0;
}
#endif

/*****************************************************************************/
/**
*
* An example of using the System ACE high-level driver interface to run
* selftest after initializont the driver
*
* @param DeviceId is the XPAR_<system_ace>_DEVICE_ID value from
*        xparameters.h
*
* @return
*
* 0 if successful, otherwise the number of errors that occurred.
*
* @note
*
* None.
*
******************************************************************************/
XStatus XSysAce_SelfTestExample(Xuint16 DeviceId)
{
    XStatus Result;

    /*
     * Initialize the instance. The device defaults to polled mode.
     */
    Result = XSysAce_Initialize(&Ace, DeviceId);
    if (Result != XST_SUCCESS)
    {
        return Result;
    }

    /*
     * Run the selftest as the example.
     */

    Result = XSysAce_SelfTest(&Ace);
    if (Result != XST_SUCCESS)
    {
        return Result;
    }

    return XST_SUCCESS;
}

