#################################################################
# Makefile generated by Xilinx Platform Studio 
# Project:C:\Data\EDK_10_1_Designs\Reference_Design_Center\Avnet_FXT_Evaluation_Board\FXT_Evaluation_SystemACE_Module_Design\FXT_Evaluation_SystemACE_Module_Design\system.xmp
#
# WARNING : This file will be re-generated every time a command
# to run a make target is invoked. So, any changes made to this  
# file manually, will be lost when make is invoked next. 
#################################################################

# Name of the Microprocessor system
# The hardware specification of the system is in file :
# C:\Data\EDK_10_1_Designs\Reference_Design_Center\Avnet_FXT_Evaluation_Board\FXT_Evaluation_SystemACE_Module_Design\FXT_Evaluation_SystemACE_Module_Design\system.mhs
# The software specification of the system is in file :
# C:\Data\EDK_10_1_Designs\Reference_Design_Center\Avnet_FXT_Evaluation_Board\FXT_Evaluation_SystemACE_Module_Design\FXT_Evaluation_SystemACE_Module_Design\system.mss

include system_incl.make

#################################################################
# PHONY TARGETS
#################################################################
.PHONY: dummy
.PHONY: netlistclean
.PHONY: bitsclean
.PHONY: simclean
.PHONY: vpclean

#################################################################
# EXTERNAL TARGETS
#################################################################
all:
	@echo "Makefile to build a Microprocessor system :"
	@echo "Run make with any of the following targets"
	@echo " "
	@echo "  netlist  : Generates the netlist for the given MHS "
	@echo "  bits     : Runs Implementation tools to generate the bitstream"
	@echo " "
	@echo "  libs     : Configures the sw libraries for this system"
	@echo "  program  : Compiles the program sources for all the processor instances"
	@echo " "
	@echo "  init_bram: Initializes bitstream with BRAM data"
	@echo "  ace      : Generate ace file from bitstream and elf"
	@echo "  download : Downloads the bitstream onto the board"
	@echo " "
	@echo "  sim      : Generates HDL simulation models and runs simulator for chosen simulation mode"
	@echo "  simmodel : Generates HDL simulation models for chosen simulation mode"
	@echo "  behavioral_model : Generates behavioral HDL models with BRAM initialization"
	@echo "  structural_model : Generates structural simulation HDL models with BRAM initialization"
	@echo "  timing   : Generates timing simulation HDL models with BRAM initialization"
	@echo "  vp       : Generates virtual platform model"
	@echo " "
	@echo "  netlistclean: Deletes netlist"
	@echo "  bitsclean: Deletes bit, ncd, bmm files"
	@echo "  hwclean  : Deletes implementation dir"
	@echo "  libsclean: Deletes sw libraries"
	@echo "  programclean: Deletes compiled ELF files"
	@echo "  swclean  : Deletes sw libraries and ELF files"
	@echo "  simclean : Deletes simulation dir"
	@echo "  vpclean  : Deletes virtualplatform dir"
	@echo "  clean    : Deletes all generated files/directories"
	@echo " "
	@echo "  make <target> : (Default)"
	@echo "      Creates a Microprocessor system using default initializations"
	@echo "      specified for each processor in MSS file"


bits: $(SYSTEM_BIT)

ace: $(SYSTEM_ACE)

netlist: $(POSTSYN_NETLIST)

libs: $(LIBRARIES)

program: $(ALL_USER_ELF_FILES)

download: $(DOWNLOAD_BIT) dummy
	@echo "*********************************************"
	@echo "Downloading Bitstream onto the target board"
	@echo "*********************************************"
	impact -batch etc/download.cmd

init_bram: $(DOWNLOAD_BIT)

sim: $(DEFAULT_SIM_SCRIPT)
	cd simulation/behavioral; \
	$(SIM_CMD)  &

simmodel: $(DEFAULT_SIM_SCRIPT)

behavioral_model: $(BEHAVIORAL_SIM_SCRIPT)

structural_model: $(STRUCTURAL_SIM_SCRIPT)

vp: $(VPEXEC)

clean: hwclean libsclean programclean simclean vpclean
	rm -f _impact.cmd
	rm -f *.log

hwclean: netlistclean bitsclean
	rm -rf implementation synthesis xst hdl
	rm -rf xst.srp $(SYSTEM).srp

netlistclean:
	rm -f $(POSTSYN_NETLIST)
	rm -f platgen.log
	rm -f $(BMM_FILE)

bitsclean:
	rm -f $(SYSTEM_BIT)
	rm -f implementation/$(SYSTEM).ncd
	rm -f implementation/$(SYSTEM)_bd.bmm 
	rm -f implementation/$(SYSTEM)_map.ncd 

simclean: 
	rm -rf simulation/behavioral
	rm -f simgen.log

swclean: libsclean programclean
	@echo ""

libsclean: $(LIBSCLEAN_TARGETS)
	rm -f libgen.log

programclean: $(PROGRAMCLEAN_TARGETS)

vpclean:
	rm -rf virtualplatform
	rm -f vpgen.log

#################################################################
# SOFTWARE PLATFORM FLOW
#################################################################


$(LIBRARIES): $(MHSFILE) $(MSSFILE) __xps/libgen.opt
	@echo "*********************************************"
	@echo "Creating software libraries..."
	@echo "*********************************************"
	libgen $(LIBGEN_OPTIONS) $(MSSFILE)


ppc440_0_libsclean:
	rm -rf ppc440_0/

#################################################################
# SOFTWARE APPLICATION SYSTEMACE_SELF_TEST
#################################################################

SystemACE_Self_Test_program: $(SYSTEMACE_SELF_TEST_OUTPUT) 

$(SYSTEMACE_SELF_TEST_OUTPUT) : $(SYSTEMACE_SELF_TEST_SOURCES) $(SYSTEMACE_SELF_TEST_HEADERS) $(SYSTEMACE_SELF_TEST_LINKER_SCRIPT) \
                    $(LIBRARIES) __xps/systemace_self_test_compiler.opt
	@mkdir -p $(SYSTEMACE_SELF_TEST_OUTPUT_DIR) 
	$(SYSTEMACE_SELF_TEST_CC) $(SYSTEMACE_SELF_TEST_CC_OPT) $(SYSTEMACE_SELF_TEST_SOURCES) -o $(SYSTEMACE_SELF_TEST_OUTPUT) \
	$(SYSTEMACE_SELF_TEST_OTHER_CC_FLAGS) $(SYSTEMACE_SELF_TEST_INCLUDES) $(SYSTEMACE_SELF_TEST_LIBPATH) \
	$(SYSTEMACE_SELF_TEST_CFLAGS) $(SYSTEMACE_SELF_TEST_LFLAGS) 
	$(SYSTEMACE_SELF_TEST_CC_SIZE) $(SYSTEMACE_SELF_TEST_OUTPUT) 
	@echo ""

SystemACE_Self_Test_programclean:
	rm -f $(SYSTEMACE_SELF_TEST_OUTPUT) 

#################################################################
# SOFTWARE APPLICATION SYSTEMACE_CF_TEST
#################################################################

SystemACE_CF_Test_program: $(SYSTEMACE_CF_TEST_OUTPUT) 

$(SYSTEMACE_CF_TEST_OUTPUT) : $(SYSTEMACE_CF_TEST_SOURCES) $(SYSTEMACE_CF_TEST_HEADERS) $(SYSTEMACE_CF_TEST_LINKER_SCRIPT) \
                    $(LIBRARIES) __xps/systemace_cf_test_compiler.opt
	@mkdir -p $(SYSTEMACE_CF_TEST_OUTPUT_DIR) 
	$(SYSTEMACE_CF_TEST_CC) $(SYSTEMACE_CF_TEST_CC_OPT) $(SYSTEMACE_CF_TEST_SOURCES) -o $(SYSTEMACE_CF_TEST_OUTPUT) \
	$(SYSTEMACE_CF_TEST_OTHER_CC_FLAGS) $(SYSTEMACE_CF_TEST_INCLUDES) $(SYSTEMACE_CF_TEST_LIBPATH) \
	$(SYSTEMACE_CF_TEST_CFLAGS) $(SYSTEMACE_CF_TEST_LFLAGS) 
	$(SYSTEMACE_CF_TEST_CC_SIZE) $(SYSTEMACE_CF_TEST_OUTPUT) 
	@echo ""

SystemACE_CF_Test_programclean:
	rm -f $(SYSTEMACE_CF_TEST_OUTPUT) 

#################################################################
# SOFTWARE APPLICATION RUNNING_FROM_DDR
#################################################################

Running_From_DDR_program: $(RUNNING_FROM_DDR_OUTPUT) 

$(RUNNING_FROM_DDR_OUTPUT) : $(RUNNING_FROM_DDR_SOURCES) $(RUNNING_FROM_DDR_HEADERS) $(RUNNING_FROM_DDR_LINKER_SCRIPT) \
                    $(LIBRARIES) __xps/running_from_ddr_compiler.opt
	@mkdir -p $(RUNNING_FROM_DDR_OUTPUT_DIR) 
	$(RUNNING_FROM_DDR_CC) $(RUNNING_FROM_DDR_CC_OPT) $(RUNNING_FROM_DDR_SOURCES) -o $(RUNNING_FROM_DDR_OUTPUT) \
	$(RUNNING_FROM_DDR_OTHER_CC_FLAGS) $(RUNNING_FROM_DDR_INCLUDES) $(RUNNING_FROM_DDR_LIBPATH) \
	$(RUNNING_FROM_DDR_CFLAGS) $(RUNNING_FROM_DDR_LFLAGS) 
	$(RUNNING_FROM_DDR_CC_SIZE) $(RUNNING_FROM_DDR_OUTPUT) 
	@echo ""

Running_From_DDR_programclean:
	rm -f $(RUNNING_FROM_DDR_OUTPUT) 

#################################################################
# BOOTLOOP ELF FILES
#################################################################



$(PPC440_0_BOOTLOOP): $(PPC440_BOOTLOOP)
	@mkdir -p $(BOOTLOOP_DIR)
	cp -f $(PPC440_BOOTLOOP) $(PPC440_0_BOOTLOOP)

#################################################################
# HARDWARE IMPLEMENTATION FLOW
#################################################################


$(BMM_FILE) \
$(WRAPPER_NGC_FILES): $(MHSFILE) __xps/platgen.opt \
                      $(CORE_STATE_DEVELOPMENT_FILES)
	@echo "****************************************************"
	@echo "Creating system netlist for hardware specification.."
	@echo "****************************************************"
	platgen $(PLATGEN_OPTIONS) $(MHSFILE)

$(POSTSYN_NETLIST): $(WRAPPER_NGC_FILES)
	@echo "Running synthesis..."
	bash -c "cd synthesis; ./synthesis.sh"

__xps/$(SYSTEM)_routed: $(FPGA_IMP_DEPENDENCY)
	@echo "*********************************************"
	@echo "Running Xilinx Implementation tools.."
	@echo "*********************************************"
	@cp -f $(UCF_FILE) implementation/$(SYSTEM).ucf
	xilperl $(NON_CYG_XILINX_EDK_DIR)/data/fpga_impl/manage_fastruntime_opt.pl $(MANAGE_FASTRT_OPTIONS)
	xflow -wd implementation -p $(DEVICE) -implement xflow.opt $(SYSTEM).ngc
	touch __xps/$(SYSTEM)_routed

$(SYSTEM_BIT): __xps/$(SYSTEM)_routed $(BITGEN_UT_FILE)
	xilperl $(NON_CYG_XILINX_EDK_DIR)/data/fpga_impl/observe_par.pl $(OBSERVE_PAR_OPTIONS) implementation/$(SYSTEM).par
	@echo "*********************************************"
	@echo "Running Bitgen.."
	@echo "*********************************************"
	@cp -f $(BITGEN_UT_FILE) implementation/bitgen.ut
	cd implementation; bitgen -w -f bitgen.ut $(SYSTEM)

$(DOWNLOAD_BIT): $(SYSTEM_BIT) $(BRAMINIT_ELF_FILES) __xps/bitinit.opt
	@cp -f implementation/$(SYSTEM)_bd.bmm .
	@echo "*********************************************"
	@echo "Initializing BRAM contents of the bitstream"
	@echo "*********************************************"
	bitinit $(MHSFILE) $(SEARCHPATHOPT) $(BRAMINIT_ELF_FILE_ARGS) \
	-bt $(SYSTEM_BIT) -o $(DOWNLOAD_BIT)
	@rm -f $(SYSTEM)_bd.bmm

$(SYSTEM_ACE): $(DOWNLOAD_BIT) $(SYSTEMACE_SELF_TEST_OUTPUT) $(SYSTEMACE_CF_TEST_OUTPUT) $(RUNNING_FROM_DDR_OUTPUT) 
	@echo "*********************************************"
	@echo "Creating system ace file"
	@echo "*********************************************"
	xmd -tcl genace.tcl -jprog -hw $(DOWNLOAD_BIT) -elf $(SYSTEMACE_SELF_TEST_OUTPUT) $(SYSTEMACE_CF_TEST_OUTPUT) $(RUNNING_FROM_DDR_OUTPUT)  -target ppc_hw  -ace $(SYSTEM_ACE)

#################################################################
# SIMULATION FLOW
#################################################################


################## BEHAVIORAL SIMULATION ##################

$(BEHAVIORAL_SIM_SCRIPT): $(MHSFILE) __xps/simgen.opt \
                          $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating behavioral simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -m behavioral $(MHSFILE)

################## STRUCTURAL SIMULATION ##################

$(STRUCTURAL_SIM_SCRIPT): $(WRAPPER_NGC_FILES) __xps/simgen.opt \
                          $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating structural simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m structural $(MHSFILE)


################## TIMING SIMULATION ##################

$(TIMING_SIM_SCRIPT): $(SYSTEM_BIT) __xps/simgen.opt \
                      $(BRAMINIT_ELF_FILES)
	@echo "*********************************************"
	@echo "Creating timing simulation models..."
	@echo "*********************************************"
	simgen $(SIMGEN_OPTIONS) -sd implementation -m timing $(MHSFILE)

#################################################################
# VIRTUAL PLATFORM FLOW
#################################################################


$(VPEXEC): $(MHSFILE) __xps/vpgen.opt
	@echo "****************************************************"
	@echo "Creating virtual platform for hardware specification.."
	@echo "****************************************************"
	vpgen $(VPGEN_OPTIONS) $(MHSFILE)

dummy:
	@echo ""

