#ifdef __MICROBLAZE__
#include "mb_interface.h"
#endif

void cpu_invalidate_dcache_range(unsigned addr, unsigned len)
{
#ifdef __MICROBLAZE__
	microblaze_init_dcache_range(addr, len);
#endif
}

#define XMK_PPC_USLEEP_WORKAROUND
#ifdef XMK_PPC_USLEEP_WORKAROUND

#include "xparameters.h"
#include "xtime_l.h"

unsigned int usleep(unsigned int useconds)
{
  XTime tEnd, tCur;

  XTime_GetTime(&tCur);
  tEnd = tCur + ((XTime) useconds) * (XPAR_CPU_PPC440_CORE_CLOCK_FREQ_HZ / 1000000);
  do
  {
    XTime_GetTime(&tCur);
  } while (tCur < tEnd);

  return 0;
}
#endif
