#include <stdio.h>

#include "xenv_standalone.h"
#include "xparameters.h"

#include "netif/xadapter.h"

#ifdef XPAR_ETHERNET_MAC_BASEADDR
#define EMAC_BASEADDR  XPAR_ETHERNET_MAC_BASEADDR
#elif XPAR_LLTEMAC_0_BASEADDR 
#define EMAC_BASEADDR  XPAR_LLTEMAC_0_BASEADDR 
#else
#error
#endif

/* list of applications to be included */
#define APP_WEBSERVER
//#define APP_TXPERF
//#define APP_RXPERF
//#define APP_ECHOSERVER


#ifdef XPAR_CPU_PPC440_CORE_CLOCK_FREQ_HZ
#define USE_UART16550
#endif

void
print_ip(char *msg, struct ip_addr *ip) 
{
	print(msg);
	xil_printf("%d.%d.%d.%d\n\r", ip4_addr1(ip), ip4_addr2(ip), 
			ip4_addr3(ip), ip4_addr4(ip));
}

void
print_ip_settings(struct ip_addr *ip, struct ip_addr *mask, struct ip_addr *gw)
{

	print_ip("Board IP: ", ip);
	print_ip("Netmask : ", mask);
	print_ip("Gateway : ", gw);
}

int main()
{
#ifdef __MICROBLAZE__
	microblaze_init_icache_range(0, XPAR_MICROBLAZE_0_CACHE_BYTE_SIZE);
	microblaze_init_dcache_range(0, XPAR_MICROBLAZE_0_DCACHE_BYTE_SIZE);

	microblaze_enable_exceptions();
#endif

	/* enable caches */
	XCACHE_ENABLE_ICACHE();
#if 0
	XCACHE_ENABLE_DCACHE();
#endif

#ifdef USE_UART16550
//#include "xuartns550_l.h"
#define UART_BAUDRATE 115200                      /* real hardware */
#define UART_BASEADDR XPAR_UARTNS550_0_BASEADDR 
#define UART_CLOCK    XPAR_XUARTNS550_CLOCK_HZ 
//	XUartNs550_SetBaud(UART_BASEADDR, UART_CLOCK, UART_BAUDRATE);
//        XUartNs550_mSetLineControlReg(UART_BASEADDR, XUN_LCR_8_DATA_BITS);
#endif

	xilkernel_main();
}

void web_application_thread();
void tx_application_thread();
void rx_application_thread();
void echo_application_thread();

struct netif server_netif;

int network_thread()
{
	struct netif *netif;
	struct ip_addr ipaddr, netmask, gw;

	/* the mac address of the board. this should be unique per board */
	unsigned char mac_ethernet_address[] = { 0x00, 0x0a, 0x35, 0x00, 0x01, 0x02 };

	netif = &server_netif;

	/* initliaze IP addresses to be used */
	IP4_ADDR(&ipaddr,  192, 168,   1, 51);
	IP4_ADDR(&netmask, 255, 255, 255,  0);
	IP4_ADDR(&gw,      192, 168,   1,  1);

	/* print all application headers */
#ifdef APP_WEBSERVER
	print_web_app_header();
#endif
#ifdef APP_RXPERF
	print_rx_app_header();
#endif
#ifdef APP_TXPERF
	print_tx_app_header();
#endif
#ifdef APP_ECHOSERVER
	print_echo_app_header();
#endif

	/* print out IP settings of the board */
	print("\n\r\n\r");
	print_ip_settings(&ipaddr, &netmask, &gw);

  	/* Add network interface to the netif_list, and set it as default */
	if (!xemac_add(netif, &ipaddr, &netmask, &gw, mac_ethernet_address, EMAC_BASEADDR)) {
		xil_printf("Error adding N/W interface\n\r");
		return -1;
	}
	netif_set_default(netif);

	/* specify that the network if is up */
	netif_set_up(netif);

	/* start packet receive thread - required for lwIP operation */
  	sys_thread_new(xemacif_input_thread, netif, DEFAULT_THREAD_PRIO);

	/* now we can start application threads */

#ifdef APP_WEBSERVER
	/* start webserver thread */
  	sys_thread_new(web_application_thread, 0, DEFAULT_THREAD_PRIO);
#endif

#ifdef APP_TXPERF
	/* start txperf thread */
  	sys_thread_new(tx_application_thread, 0, DEFAULT_THREAD_PRIO);
#endif

#ifdef APP_RXPERF
	/* start rxperf thread */
  	sys_thread_new(rx_application_thread, 0, DEFAULT_THREAD_PRIO);
#endif

#ifdef APP_ECHOSERVER
	/* start echo server thread */
  	sys_thread_new(echo_application_thread, 0, DEFAULT_THREAD_PRIO);
#endif

	return 0;
}

int main_thread()
{
	/* initialize lwIP before calling sys_thread_new */
	lwip_init();

	/* any thread using lwIP should be created using sys_thread_new */
  	sys_thread_new(network_thread, NULL, DEFAULT_THREAD_PRIO);
}
