#include <stdio.h>
#include <string.h>

#include "xmk.h"
#include "lwip/inet.h"
#include "lwip/sockets.h"
#include "lwipopts.h"

#include "webserver.h"

/* thread spawned for each connection */
void 
process_http_request(int sd)
{
	int read_len;
	int RECV_BUF_SIZE = 600;                        /* http request size can be a max of RECV_BUF_SIZE */
	unsigned char recv_buf[RECV_BUF_SIZE];		/* since these buffers are allocated on the stack .. */
							/* .. care should be taken to ensure there are no overflows */
	
	/* read in the request */
	if ((read_len = read(sd, recv_buf, RECV_BUF_SIZE)) < 0)
		return;

	/* respond to request */
	generate_response(sd, recv_buf, read_len);

	/* close connection */
	close(sd);
}

/* http server */
int 
web_application_thread()
{
	int sock, new_sd;
	struct sockaddr_in address, remote;
	int size;

	/* initialize file system layer */
	platform_init_fs();

	/* initialize devices */
	platform_init_gpios();

	/* create a TCP socket */
	if ((sock = lwip_socket(AF_INET, SOCK_STREAM, 0)) < 0)
		return;

	/* bind to port 80 at any interface */
	address.sin_family = AF_INET;
	address.sin_port = htons(80);
	address.sin_addr.s_addr = INADDR_ANY;
	if (lwip_bind(sock, (struct sockaddr *)&address, sizeof (address)) < 0)
		return;

	/* listen for incoming connections */
	lwip_listen(sock, 5);

	size = sizeof(remote);
	while (1) {
		new_sd = lwip_accept(sock, (struct sockaddr *)&remote, &size);

		/* spawn a separate handler for each request */
		sys_thread_new(process_http_request, (void*)new_sd, DEFAULT_THREAD_PRIO);
	}
}

void 
print_web_app_header()
{
	xil_printf("\n\r\n\r-----lwIP test WebServer ------\n\r");
	xil_printf("Open up your favorite browser and type: \n\r");
	xil_printf("http://192.168.1.51\n\r");
}
