#!/bin/bash
# PicoBlaze code bitstream replacer 
# modified by k.m. 2012.03.23

usage() {
	cat << EOF

  usage: $0 -b BIT_NAME [-m MEM_NAME -r RAM_MODULE_NAME -i IMPACT_SCRIPT -p -d]

  This script replace picoBlaze program in bitstream file and load it into FPGA using Impact.

  OPTIONS:
    -b	File containing bitstream 
    -m	File containing translated picoBlaze code
    -r	Ram module name (default='ram_1024_x_18')
    -d	Repleace data memory (use ram module name='ram_2048_x_9' if option '-r' is not used)
    -i	Source impact script for different board (default Spartan-3AN Design Kit)
    -p	Program FPGA
    -h	Show this message

  Examples:
    $0 -b my_design -m my_psm -p
      Replace bitstream '../my_design.bit' with translated code 'my_psm.mem' and program FPGA

    $0 -b my_design -p
      Program FPGA using '../my_design.bit' without changing it.

    $0 -b my_design -m my_psm
      Replace bitstream '../my_design.bit' with translated code 'my_psm.mem'.

		$0 -b my_design -m my_data -d
      Replace data mempry in bitstream '../my_design.bit' with data 'my_data.mem'.

EOF
}

PATH=$PATH:/opt/Xilinx/12.4/ISE_DS/ISE/bin/lin64
#PATH=$PATH:/drives/g/Xilinx/12.4/ISE_DS/ISE/bin/nt
#PATH=$PATH:/drives/c/Xilinx/12.2/ISE_DS/ISE/bin/nt64 

BIT_NAME=
MEM_NAME=
RAM_NAME=ram_1024_x_18
RAM_OPTION_USED=
DO_IMPACT=
RAM_DATA=
IMPACT_SCRIPT=

while getopts "b:m:r:i:phd" OPTION
do
	case $OPTION in
		b)
			BIT_NAME=$OPTARG
			;;
		m)
			MEM_NAME=$OPTARG
			;;
		r)
			RAM_NAME=$OPTARG
			RAM_OPTION_USED=t
			;;
		i)
			IMPACT_SCRIPT=$OPTARG
			;;
		p)
			DO_IMPACT=t
			;;
		d)
			RAM_DATA=t
			;;
		h)
			usage
			exit
			;;
		?)
			usage
			exit 1
			;;
	esac
done

if ! [ -n "$RAM_OPTION_USED" ]; then
	if [ -n "$RAM_DATA" ]; then
		RAM_NAME=ram_2048_x_9
	fi
fi

MOD_OK=
PROG_OK=
if [ -n "$BIT_NAME" ]; then
	BIT_PATH="$( readlink -f "$( dirname "$BIT_NAME" )")"
	BIT_FILE_NAME=$( basename "$BIT_NAME" )
	BIT_FILE_NAME=${BIT_FILE_NAME%.*}
	if ! [ -e $BIT_PATH/$BIT_FILE_NAME.bit ]; then
		echo ERR: File "'$BIT_PATH/$BIT_FILE_NAME.bit'" does not exist!
		exit 1
	else
		if [ -n "$MEM_NAME" ] && [ -n "$RAM_NAME" ]; then
				MEM_PATH="$( readlink -f "$( dirname "$MEM_NAME" )")"
				MEM_FILE_NAME=$( basename "$MEM_NAME" )
			if ! [ -e $BIT_PATH/$BIT_FILE_NAME.ncd ]; then
				echo ERR: File "'$BIT_PATH/$BIT_FILE_NAME.ncd'" does not exist!
				exit 1
			elif ! [ -e $MEM_PATH/$MEM_FILE_NAME ]; then
				echo ERR: File "'$MEM_PATH/$MEM_FILE_NAME'" does not exist!
				exit 1
			else
				MOD_OK=t
			fi
		fi
		if [ -n "$DO_IMPACT" ]; then
			if [ -n "$IMPACT_SCRIPT" ]; then
				if ! [ -e $IMPACT_SCRIPT ]; then
					echo ERR: File "'$IMPACT_SCRIPT'" does not exist!
					exit 1
				else
					PROG_OK=t
				fi
			else
				PROG_OK=t
			fi
		fi
	fi 
fi

if [ -z $MOD_OK ] && [ -z $PROG_OK ]; then
  usage
  exit 1
else
	if [ -n "$MOD_OK" ]; then
		TMP="$(sed -n '2p' $MEM_PATH/$MEM_FILE_NAME)"
		if [ "${TMP:0:1}" == "@" ]; then
			echo "Converting adresses in '$MEM_PATH/$MEM_FILE_NAME'."
			sed -i -r -e '1!s/@[0-9ABCDEF]+  //g' -e 's/ 000/ /g' -e 's/^000//g' $MEM_PATH/$MEM_FILE_NAME
		fi
		echo "Replacing '$MEM_NAME' in '$RAM_NAME'"
		./bitUpdate.bash $RAM_NAME $BIT_PATH/$BIT_FILE_NAME.ncd $MEM_PATH/$MEM_FILE_NAME $BIT_PATH/$BIT_FILE_NAME.bit

		cp $BIT_PATH/$BIT_FILE_NAME.bit $BIT_PATH/${BIT_FILE_NAME}_old.bit
		mv download.bit $BIT_PATH/$BIT_FILE_NAME.bit
	fi

	if [ -n "$PROG_OK" ]; then
		if [ -n "$IMPACT_SCRIPT" ]; then
			if [ -e $IMPACT_SCRIPT ]; then
				sed "s:BIT_NAME:$BIT_PATH/$BIT_FILE_NAME:" $IMPACT_SCRIPT > impact.cmd
				if [ -e impact.cmd ]; then
					impact -batch impact.cmd
					rm impact.cmd
				else
					echo ERR: File 'impact.cmd' was not created from "'$IMPACT_SCRIPT'"!
					exit 1
				fi
			else
				echo ERR: File "'$IMPACT_SCRIPT'" does not exist!
			fi
		else
			echo setmode -bscan > impact.cmd
			echo setCable -p auto >> impact.cmd
			echo identify >> impact.cmd
			echo assignfile -p 1 -file "$BIT_PATH/$BIT_FILE_NAME".bit >> impact.cmd
			echo program -p 1 -onlyFpga >> impact.cmd
			echo quit >> impact.cmd
			if [ -e impact.cmd ]; then
				impact -batch impact.cmd
				rm impact.cmd
			else
				echo ERR: Default "file" 'impact.cmd' was not created by this script!
				exit 1
			fi
		fi
	fi
fi
