#include "printf.h"

//#define pgm_read_byte *


void _p_puts(char const *p)
{
	u08 b;
	while (p && (b = pgm_read_byte(p++)))
		uart_sendchar(b);
}
/*
void _p_puts(char const *p)
{
	u08 b;
	while (p && (b = pgm_read_byte(p++)))
		uart_sendchar(b);
}
*/
int _p_vprintf(char const *format,va_list ap)
{
  u08 	scratch[16];
  u08 	format_flag;
  u32 	u_val=0;
  u08	base;
  u08	*ptr;
  u08	width;
  u08 	fill;

  while(1)
  {
  
  	width = 0;
  	fill = ' ';
    while ((format_flag = pgm_read_byte(format++)) != '%')
	{  
      if (!format_flag)
	  {
		  va_end (ap); 
		  return (0);
	  }
      uart_sendchar(format_flag);
    }


	// check for zero pad
	format_flag = pgm_read_byte(format) - '0'; 
	if (format_flag == 0)	// zero pad
	{
		fill = '0';
		format++;
	}
	
	// check for width spec
	format_flag = pgm_read_byte(format) - '0'; 
	if (format_flag > 0 && format_flag <= 9)	// width set
	{
		width = format_flag;
		format++;	
	}
	
    switch (format_flag = pgm_read_byte(format++))
	{
		case 'c':
		  format_flag = va_arg(ap,int);

		  //fall through
		  
		default:
		  uart_sendchar(format_flag);
		  continue;
		  
		case 'S':
		case 's':
		  ptr = (u08 *)va_arg(ap,char *);
		  while (*ptr)
			uart_sendchar(*ptr++);
		  continue;

		case 'u':
	  	  u_val = va_arg(ap,unsigned int);
		  base = 10;
		  goto CONVERSION_LOOP;


		case 'b':
	  	  u_val = va_arg(ap,unsigned int);
		  base = 2;
		  goto CONVERSION_LOOP;		  
		  
		case 'x':
	  	  u_val = va_arg(ap,unsigned int);
		  base = 16;

		case 'U':
	  	  u_val = va_arg(ap,u32);
		  base = 10;
		  goto CONVERSION_LOOP;

CONVERSION_LOOP:
		  ptr = scratch + 16;
		  *--ptr = 0;
		  do
		  {
			char ch = u_val % base + '0';
			if (ch > '9')
			  ch += 'a' - '9' - 1;
			*--ptr = ch;
			u_val /= base;

			if (width)
				width--;
		
	      } while (u_val);

		  while (width--)
		  	*--ptr = fill; 		      
	      
		  while (*ptr)
			uart_sendchar(*ptr++);
    }
  }

}

int _p_printf(char const *format, ...)
{
  	va_list ap;
  	va_start (ap, format);
  	return _p_vprintf(format,ap);
}


