#ifndef _PRINTF_H_
#define _PRINTF_H_

#include <stdarg.h>
#include <string.h>
#include <avr/pgmspace.h>
#include "uart.h"
#include "types.h"


int _p_printf(char const *fmt0, ...);
void _p_puts(char const *s);



#define printf(format, args...)   _p_printf(PSTR(format), ## args)
#define puts(str)   		_p_puts(PSTR(str))


#endif
