#ifndef _TYPES_H_
#define _TYPES_H_


#define MAX_U16  65535
#define MAX_S16  32767

#define DDR(x) ((x)-1)    // address of data direction register of port x 
#define PIN(x) ((x)-2)    // address of input register of port x 

//
// basic unsigned types
//
typedef unsigned char  u08;
typedef unsigned short u16;
typedef unsigned long  u32;

//
// basic signed types
//
typedef char  s08;
typedef short s16;
typedef long  s32;

#ifndef NULL
#define NULL    0
#endif

// Make an unsigned copy of div function
typedef struct {
	unsigned quot;
	unsigned rem;
} udiv_t;
//extern udiv_t udiv(unsigned, unsigned) __asm__("__udivmodhi4") __ATTR_CONST__;

// This structures are used to simplify code, compiler doesn't optimize 
// well shifts
struct u16bytes
{
	u08 low, high;
};

union u16convert
{
	u16 value;
	struct u16bytes bytes;
};

struct u32bytes
{
	u08 byte1, byte2, byte3, byte4;
};

struct u32words
{
	u16 low, high;
};

union u32convert 
{
	u32 value;
	struct u32bytes bytes;
	struct u32words words;
};

/**
   \ingroup deprecated_items
   \def sbi(port, bit)
   \deprecated

   Set \c bit in IO port \c port.
*/
#define sbi(port, bit) (port) |= (1 << (bit))

/**
   \ingroup deprecated_items
   \def cbi(port, bit)
   \deprecated

   Clear \c bit in IO port \c port.
*/
#define cbi(port, bit) (port) &= ~(1 << (bit))

#define true 1
#define false 0
#endif
