#include <avr/io.h>
#include "uart.h"


void uart_init( void )
{
//unsigned int ubrr=15;
unsigned int ubrr=103;
/* Set baud rate */
UBRRH = (unsigned char)(ubrr>>8);
UBRRL = (unsigned char)ubrr;

//UCSRA = (1<<U2X);
/* Enable receiver and transmitter */
UCSRB = (1<<RXEN)|(1<<TXEN);
/* Set frame format: 8data, 1stop bit */
//UCSRC = (3<<UCSZ0);

UCSRA|=(1<<U2X);
//UBRRL=15;
//UBRRH=0;
}

void uart_sendchar( unsigned char c )
{
/* Put data into buffer, sends the data */
while ( !( UCSRA & (1<<UDRE)) );
UDR = c;
}


unsigned char  uart_is_received_byte( void )
{
 return (UCSRA & (1<<RXC));
}

unsigned char  uart_getchar( void )
{
/* Wait for data to be received */
while ( !(UCSRA & (1<<RXC)) )
;
/* Get and return received data from buffer */
return UDR;
}
